//INT070_Touch_lib_XC32.h


#include <p32xxxx.h>
    
// Port definition and Port control command definition 
//TP_DIN (RA6: SDO mode)
#define TPMOSIConfig() (TRISAbits.TRISA6 = 0)	//RA6:out
#define TPMOSIHigh()   (LATAbits.LATA6 = 1)
#define TPMOSILow()    (LATAbits.LATA6 = 0)

//TP_DOUT (RE8: SDI mode)
#define TPMISOConfig() (TRISEbits.TRISE8 = 1)	//RE8: in mode
#define TPMISOConfig2() (ANSELEbits.ANSE8 = 0)  //RE8: Digital mode
#define TPMISOHigh()   (LATEbits.LATE8 = 1)
#define TPMISOLow()    (LATEbits.LATE8 = 0)
#define TPMISORead()   (PORTEbits.RE8)

//TP_CLK (RA7: SCK mode)   
#define TPSCLConfig()  (TRISAbits.TRISA7 = 0)	//RA7: out mode
#define TPSCLHigh()    (LATAbits.LATA7 = 1)
#define TPSCLLow()     (LATAbits.LATA7 = 0)

//TP_CS (RE9: Chip Select mode)
#define TPCSConfig()   (TRISEbits.TRISE9 = 0)	//RE9: out mode
#define TPCSConfig2()   (ANSELEbits.ANSE9 = 0)  //RE9: Digital mode
#define TPCSHigh()     (LATEbits.LATE9 = 1)
#define TPCSLow()      (LATEbits.LATE9 = 0)


//TP_TIRQ   //Pulse out when touch on INT070 display
#define TPIRQConfig() 
#define TPIRQRead()


//Port Initialize function 
#define InitBitBangedIO(){ \
    TPMOSIHigh();   \
    TPMOSIConfig(); \
    TPMISOConfig(); \
    TPMISOConfig2();    \
    TPSCLLow();		\
    TPSCLConfig();  \
    TPCSHigh();     \
    TPCSConfig();   \
    TPCSConfig2();  \
}



void ys_TouchHardwareInit(void);	
short ys_TouchDetectPosition(void);	
void ys_TPWriteCommand(unsigned char cmd, unsigned char dat);
void ys_TPWriteByte(unsigned char value);
unsigned char ys_TPReadCommand(unsigned char cmd);
unsigned char ys_TPReadByte(void);
short ys_TouchDetectPosition(void);
short ys_TouchGetX(void);
short ys_TouchGetRawX(void);
short ys_TouchGetY(void);
short ys_TouchGetRawY(void); 

int INT070_TouchDetect(void);
   
        
